<?php
	ob_start();
	require_once("../includes/login-session.php"); 
	require_once("../includes/initialize.php"); 

	ini_set('display_errors', 1);
	error_reporting(E_ALL);

    if (!$login_session->is_admin_logged_in()) { redirect_to("../../admin/"); }
    else { $user_level = Levels::find_by_username($login_session->admin_id); if($user_level->id_card != 1){ redirect_to("../../admin/"); } }

	date_default_timezone_set('Asia/Calcutta');


	// foreach ($_FILES['employee_photo'] as $key => $value) {
	// 	echo htmlspecialchars($key)." = ".htmlspecialchars($value)."<br>";
	// };

	// return false;


	$total = count($_FILES['employee_photo']['name']);
	$error_messages = "";
	$error_count = 0;
	
	for($i=0; $i<$total; $i++) {
		$photo = $_FILES['employee_photo']['name'][$i];
		
		$photo_details = new SplFileInfo($photo);
		$ext = $photo_details->getExtension();	

		if($ext != 'jpg' && $ext != 'jpeg' && $ext != 'png'){
			if(!$employee){
				$error_count++;
				$error_messages .= "<i class='fa fa-times' style='color: #a00;'></i> Error on Photo <span class='text-danger'>{$photo}</span>: Invalid Photo format <span class='text-danger'>.{$ext}</span>  <span class='text-success'>(Valid Photo format is jpg/jpeg/png)</span><br />";	
			}
		}

		$photo_code = str_replace(".".$ext,"",$photo);	

		$employee = Employee::find_by_emp_code($photo_code);
		if(!$employee){
        	$employee = NonAppEmployee::find_by_emp_code($photo_code);        
		}

		if(!$employee){
			$error_count++;
			$error_messages .= "<i class='fa fa-times' style='color: #a00;'></i> Error on Photo <span class='text-danger'>{$photo}</span>: Employee Code <span class='text-danger'>{$photo_code}</span> not found.<br />";	
		}

	};
	

	if($error_count > 0){
?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
            	<?php echo $error_messages; ?>
            	<hr />
            	<a href="upload-employee-photo.php?cid=<?php echo $_GET['cid']; ?>" class="btn btn-danger waves-effect waves-light"><i class="mdi mdi-keyboard-backspace me-1"></i> Upload Photo again</a>
            </div>
        </div>
    </div>
</div>

<?php
	} else {

    	
    	$total = count($_FILES['employee_photo']['name']);

		for($i=0; $i<$total; $i++) {

			if ($_FILES["employee_photo"]["error"][$i] > 0){
	    		echo json_encode("Error Code: " . $_FILES["employee_photo"]["error"][$i]);
	    	} else {

	    		$target_path = "../documents/photos/";
	    		if (!file_exists($target_path)) {
	                mkdir($target_path, 0777, true);
	            }
	            
	            $image_basename 	= basename( $_FILES['employee_photo']['name'][$i]);
	            $remove 			= strstr($image_basename,"?");
			    $image_name 		= str_replace($remove,"",$image_basename);
	            $target_path 		= $target_path . $image_name;
	            
	            move_uploaded_file($_FILES['employee_photo']['tmp_name'][$i], $target_path);
	      	}

		}

		$session->message("{$total} Photos Uploaded Successfully");
		redirect_to("upload-employee-photo.php?cid=".$_GET['cid']); 
		
	}
?>
<link href="../assets/css/config/default/bootstrap.min.css" rel="stylesheet" type="text/css" id="bs-default-stylesheet" />
<link href="../assets/css/icons.min.css" rel="stylesheet" type="text/css" />